
import { initializeApp } from 'firebase/app';
import { getFirestore, collection, writeBatch, doc } from 'firebase/firestore';
import { firebaseConfig } from '../src/firebase/config';
import { initialProducts, initialGalleryImages } from '../src/lib/data';
import dotenv from 'dotenv';

dotenv.config({ path: '.env' });

async function seedDatabase() {
  console.log('Using Firebase config:', firebaseConfig);

  const firebaseApp = initializeApp(firebaseConfig);
  const firestore = getFirestore(firebaseApp);

  try {
    const batch = writeBatch(firestore);

    // Seed Products
    console.log('Seeding products...');
    const productsCollection = collection(firestore, 'products');
    for (const product of initialProducts) {
      const newProductRef = doc(productsCollection);
      batch.set(newProductRef, product);
    }
    console.log(`${initialProducts.length} products prepared for seeding.`);

    // Seed Gallery Images
    console.log('Seeding gallery images...');
    const galleryCollection = collection(firestore, 'gallery');
    for (const image of initialGalleryImages) {
        const newImageRef = doc(galleryCollection);
        batch.set(newImageRef, image);
    }
    console.log(`${initialGalleryImages.length} gallery images prepared for seeding.`);

    // Commit the batch to write all data to the database
    await batch.commit();
    console.log('Database seeded successfully!');

  } catch (error) {
    console.error('Error seeding database:', error);
  } finally {
    // Disconnect and terminate the script
    process.exit(0);
  }
}

seedDatabase();
