import { z } from 'zod';

export const repairBookingFormSchema = z.object({
    name: z.string().min(2, { message: 'Name must be at least 2 characters.' }),
    phone: z.string().min(8, { message: 'Please enter a valid phone number.' }),
    device: z.string().min(3, { message: 'Please specify your device model.' }),
    issue: z.string().min(10, { message: 'Please describe the issue in at least 10 characters.' }),
});
