
export type Product = {
  id?: string;
  name: string;
  description: string;
  image: string; // Main Image URL
  image2?: string;
  image3?: string;
  image4?: string;
  category: string;
  review?: string;
  reviewerName?: string;
  rating?: number;
};

export type GalleryImage = {
  id?: string;
  imageUrl: string;
  description: string;
  imageHint: string;
  name?: string;
  role?: string;
};

export type Category = {
  id: string;
  name: string;
  description: string;
};

export type Testimonial = {
  id?: string;
  name: string;
  location: string;
  quote: string;
};

export type Comment = {
  id?: string;
  authorName: string;
  rating: number;
  text: string;
  createdAt: any;
};

export const categories: Category[] = [
  { id: 'screens', name: 'Screens', description: 'High-quality replacement screens for all major brands.' },
  { id: 'accessories', name: 'Accessories', description: 'Chargers, earbuds, smartwatches and more.' },
  { id: 'powerbanks', name: 'Power Banks', description: 'Portable chargers to keep your devices powered on the go.' },
  { id: 'security-cameras', name: 'Security Cameras', description: 'Keep your home or business safe with our high-quality security cameras.' },
  { id: 'tools-repair', name: 'Tools & Repair Kits', description: 'REPAIR KITS WE USE TO DO OUR REPAIR' },
  { id: 'microphones', name: 'Microphones', description: 'Professional and consumer-grade microphones for all your audio needs.' },
  { id: 'mifi', name: 'MiFi', description: 'Portable MiFi devices for internet on the go.' },
];

export const initialTestimonials: Omit<Testimonial, 'id'>[] = [
  { name: 'Mariatu K.', location: 'Freetown', quote: 'Excellent service, got my phone fixed same day! The new screen is perfect.' },
  { name: 'John P.', location: 'Bo', quote: 'I ordered a power bank and it was delivered quickly. Great quality product.' },
  { name: 'Aisha B.', location: 'Kenema', quote: 'The staff are very knowledgeable and helped me choose the right security camera for my home.' },
  { name: 'David S.', location: 'Makeni', quote: 'REGIMENZ is the most reliable electronics shop. Genuine parts and fair prices.' },
];

export const navLinks = [
    { href: '/', label: 'Home' },
    { href: '/products', label: 'Products' },
    { href: '/repairs', label: 'Repairs' },
    { href: '/about', label: 'About Us' },
    { href: '/contact', label: 'Contact' },
];

export const siteConfig = {
    name: 'REGIMENZ ELECTRONICS INVESTMENT',
    ceo: 'Mr James R. O Macauley',
    logo: '/logo.png',
    location: '31 Garrison Street, Freetown',
    established: 'May 26, 2025',
    phone: '099675032',
    whatsappLink: 'https://wa.me/23299675032',
    googleMapsLink: 'https://www.google.com/maps/search/?api=1&query=31+Garrison+Street+Freetown',
    googleMapsEmbed: 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3943.141527011993!2d-13.23512398521516!3d8.48493409380962!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0xf04df34925394e3%3A0x80b6564694939dc6!2s31%20Garrison%20St%2C%20Freetown%2C%20Sierra%20Leone!5e0!3m2!1sen!2sus!4v1620912100000!5m2!1sen!2sus',
};

export const initialProducts: Omit<Product, 'id'>[] = [
  // This is now being loaded from Firestore
];

export const initialGalleryImages: Omit<GalleryImage, 'id'>[] = [
  {
    imageUrl: 'https://images.unsplash.com/photo-1555774698-0b77e0abfe79?w=600&q=80',
    description: 'Our modern and clean storefront, located in the heart of Freetown.',
    imageHint: 'storefront modern',
  },
  {
    imageUrl: 'https://images.unsplash.com/photo-1563291074-2bf8677363a0?w=600&q=80',
    description: 'One of our certified technicians carefully repairing a smartphone.',
    imageHint: 'technician repair',
  },
  {
    imageUrl: 'https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=600&q=80',
    description: 'Our wide selection of genuine parts and accessories.',
    imageHint: 'parts accessories',
  },
  {
    imageUrl: 'https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?w=600&q=80',
    description: 'A happy customer getting advice from our friendly staff.',
    imageHint: 'customer service',
  },
  {
    imageUrl: 'https://images.unsplash.com/photo-1558339226-c52973403d27?w=600&q=80',
    description: 'Detailed view of a circuit board during a complex repair.',
    imageHint: 'circuit board',
  },
  {
    imageUrl: 'https://images.unsplash.com/photo-1581090464777-f3220bbe1b8b?w=600&q=80',
    description: 'Our state-of-the-art repair lab with advanced diagnostic tools.',
    imageHint: 'repair lab',
  },
];
