import Link from 'next/link';
import Image from 'next/image';

export function Logo({ siteName, logoUrl }: { siteName: string, logoUrl: string }) {
  return (
    <Link href="/" className="flex items-center gap-2">
      {logoUrl ? (
        <Image
          src={logoUrl}
          alt={`${siteName} Logo`}
          width={40}
          height={40}
          className="rounded-full object-cover"
        />
      ) : (
        <div className="h-10 w-10 rounded-full bg-muted"></div>
      )}
      <span className="hidden text-lg font-semibold sm:inline-block sr-only">
        {siteName}
      </span>
    </Link>
  );
}
