'use client';

import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Heart, ThumbsUp, Users } from 'lucide-react';

export function WhyChooseUs() {
  return (
    <section className="py-12 md:py-20 bg-muted/50">
      <div className="container">
        <h2 className="mb-8 text-center text-3xl font-bold tracking-tight md:text-4xl">
          Why Choose Us?
        </h2>
        <div className="grid gap-8 md:grid-cols-3">
          <Card>
            <CardHeader className="flex-row items-center gap-4">
              <Users className="h-10 w-10 text-primary" />
              <CardTitle>Expert Team</CardTitle>
            </CardHeader>
            <CardContent>
              <p className="text-muted-foreground">
                Our technicians are certified and passionate about technology, ensuring your devices are handled with professional care.
              </p>
            </CardContent>
          </Card>
          <Card>
            <CardHeader className="flex-row items-center gap-4">
              <ThumbsUp className="h-10 w-10 text-primary" />
              <CardTitle>Quality Guaranteed</CardTitle>
            </CardHeader>
            <CardContent>
              <p className="text-muted-foreground">
                We stand by our work. We use only genuine parts and offer warranties on our repairs and products for your peace of mind.
              </p>
            </CardContent>
          </Card>
          <Card>
            <CardHeader className="flex-row items-center gap-4">
              <Heart className="h-10 w-10 text-primary" />
              <CardTitle>Customer First</CardTitle>
            </CardHeader>
            <CardContent>
              <p className="text-muted-foreground">
                  Your satisfaction is our priority. We provide transparent pricing, honest advice, and friendly service every time.
              </p>
            </CardContent>
          </Card>
        </div>
      </div>
    </section>
  );
}
