'use client';

import { Card, CardContent, CardHeader } from '@/components/ui/card';
import { initialTestimonials, type Testimonial } from '@/lib/data';
import { Star, User } from 'lucide-react';
import { Avatar, AvatarFallback } from '../ui/avatar';

export function Testimonials() {

  return (
    <div className="container mx-auto">
      <h2 className="mb-8 text-center text-3xl font-bold tracking-tight md:text-4xl">
        What Our Customers Say
      </h2>
      <div className="grid grid-cols-1 gap-6 md:grid-cols-2 lg:grid-cols-2">
        {initialTestimonials.map((testimonial, index) => (
          <Card key={index} className="flex flex-col bg-card">
            <CardHeader>
              <div className="flex items-center gap-4">
                <Avatar>
                  <AvatarFallback>
                    <User className="h-5 w-5" />
                  </AvatarFallback>
                </Avatar>
                <div>
                  <p className="font-semibold">{testimonial.name}</p>
                  <p className="text-sm text-muted-foreground">{testimonial.location}</p>
                </div>
              </div>
            </CardHeader>
            <CardContent className="flex flex-1 flex-col">
              <div className="flex items-center gap-1 text-yellow-500">
                {[...Array(5)].map((_, i) => (
                  <Star key={i} className="h-5 w-5 fill-current" />
                ))}
              </div>
              <blockquote className="mt-4 flex-1 border-l-2 border-primary pl-4 text-muted-foreground">
                {testimonial.quote}
              </blockquote>
            </CardContent>
          </Card>
        ))}
      </div>
    </div>
  );
}
