'use client';

import Link from 'next/link';
import { Button } from '@/components/ui/button';
import { useSiteConfig } from '@/hooks/use-site-config';

export function Hero() {
  const { siteConfig } = useSiteConfig();

  const companyNameParts = siteConfig.name.split(' ');
  const firstWord = companyNameParts[0];
  const restOfName = companyNameParts.slice(1).join(' ');

  return (
    <section className="w-full bg-primary py-20 text-white">
        <div className="container flex flex-col items-center justify-center text-center">
            <h1 className="text-4xl font-extrabold tracking-tight sm:text-5xl md:text-6xl lg:text-7xl">
                <span className="block">{firstWord}</span>
                <span className="block">{restOfName}</span>
            </h1>
            <p className="mt-4 max-w-2xl text-lg md:text-xl">
                Freetown's #1 destination for genuine electronic parts, accessories, and expert repairs.
            </p>
            <div className="mt-8 flex flex-wrap justify-center gap-4">
                <Button asChild size="lg" variant="secondary">
                    <Link href="/products">Explore Products</Link>
                </Button>
                <Button asChild variant="outline" size="lg" className="border-white text-white hover:bg-white hover:text-primary">
                    <Link href="/contact">Contact Us</Link>
                </Button>
            </div>
        </div>
    </section>
  );
}
