'use client';

import Image from 'next/image';
import { type Product } from '@/lib/data';
import { Card, CardContent, CardFooter, CardHeader, CardTitle } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import { Button } from '@/components/ui/button';
import Link from 'next/link';
import { Star } from 'lucide-react';
import { cn } from '@/lib/utils';

interface ProductCardProps {
  product: Product;
}

export function ProductCard({ product }: ProductCardProps) {
  return (
    <Card className="flex h-full flex-col overflow-hidden transition-shadow hover:shadow-lg">
      <Link href={`/products/${product.id}`} className="flex flex-col flex-1">
          <CardHeader className="relative p-0">
            {product.image ? (
              <Image
                src={product.image}
                alt={product.name}
                width={600}
                height={600}
                className="aspect-square w-full object-cover"
              />
            ) : (
              <div className="aspect-square w-full bg-muted"></div>
            )}
            <Badge variant="secondary" className="absolute right-2 top-2">
              {product.category}
            </Badge>
          </CardHeader>
          <CardContent className="flex-1 p-4">
            {product.rating && product.rating > 0 && (
                <div className="flex items-center mb-2">
                    {[...Array(5)].map((_, i) => (
                        <Star key={i} className={cn("h-5 w-5", i < product.rating! ? "fill-yellow-400 text-yellow-400" : "fill-muted stroke-muted-foreground")} />
                    ))}
                </div>
            )}
            <CardTitle className="mb-2 text-lg">{product.name}</CardTitle>
            <p className="text-sm text-muted-foreground line-clamp-3">{product.description}</p>
          </CardContent>
      </Link>
      <CardFooter className="p-4 pt-0 mt-auto">
        <Button asChild className="w-full">
          <Link href={`/products/${product.id}`}>View Details</Link>
        </Button>
      </CardFooter>
    </Card>
  );
}
