'use client';

import { Phone, MapPin, Mail, MessageCircle, User } from 'lucide-react';
import { navLinks } from '@/lib/data';
import Link from 'next/link';
import { useSiteConfig } from '@/hooks/use-site-config';
import { useState } from 'react';

export function Footer() {
  const { siteConfig } = useSiteConfig();
  const [adminClickCount, setAdminClickCount] = useState(0);
  
  const emailSubject = "Inquiry from Regimenz Electronics Website";
  const emailBody = "Hello Regimenz Team,\n\nI am writing to inquire about...\n\nBest regards,";
  const mailtoLink = `mailto:regimenzinvestment121@gmail.com?subject=${encodeURIComponent(emailSubject)}&body=${encodeURIComponent(emailBody)}`;

  const socialLinks = [
    { name: 'WhatsApp', icon: MessageCircle, href: `https://wa.me/232099675032` },
    { name: 'Email', icon: Mail, href: mailtoLink },
  ];
  
  const handleCopyrightClick = () => {
    setAdminClickCount(prev => prev + 1);
  };


  return (
    <footer className="bg-muted/50">
      <div className="container py-12">
        <div className="grid grid-cols-1 gap-8 md:grid-cols-4">
          <div className="space-y-4">
            <Link href="/" className="font-bold text-lg">{siteConfig.name}</Link>
            <p className="text-sm text-muted-foreground">
              Your one-stop shop for electronic investments, repairs, and accessories.
            </p>
          </div>
          <div>
            <h4 className="mb-4 font-semibold">Quick Links</h4>
            <ul className="space-y-2">
              {navLinks.map((link) => (
                <li key={link.href}>
                  <Link href={link.href} className="text-sm text-muted-foreground hover:text-primary">
                    {link.label}
                  </Link>
                </li>
              ))}
               {adminClickCount >= 5 && (
                <li>
                    <Link href="/admin" className="flex items-center gap-1 text-sm text-muted-foreground hover:text-primary">
                    <User className="h-4 w-4" />
                    Admin
                    </Link>
                </li>
                )}
            </ul>
          </div>
          <div>
            <h4 className="mb-4 font-semibold">Contact Us</h4>
            <ul className="space-y-2 text-sm text-muted-foreground">
              <li className="flex items-start gap-2">
                <MapPin className="mt-1 h-4 w-4 shrink-0" />
                <span>{siteConfig.location}</span>
              </li>
              <li className="flex items-center gap-2">
                <Phone className="h-4 w-4 shrink-0" />
                <a href={`tel:${siteConfig.phone}`} className="hover:text-primary">
                  {siteConfig.phone}
                </a>
              </li>
            </ul>
            <div className="mt-4 flex space-x-4">
              {socialLinks.map((link) => (
                <a
                  key={link.name}
                  href={link.href}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="text-muted-foreground hover:text-primary"
                >
                  <link.icon className="h-6 w-6" />
                  <span className="sr-only">{link.name}</span>
                </a>
              ))}
            </div>
          </div>
          <div>
            <h4 className="mb-4 font-semibold">About the Company</h4>
            <p className="text-sm text-muted-foreground">
              CEO: {siteConfig.ceo}
              <br />
              Established: {siteConfig.established}
            </p>
          </div>
        </div>
        <div 
          className="mt-8 border-t pt-8 text-center text-sm text-muted-foreground"
          onClick={handleCopyrightClick}
          style={{ cursor: 'pointer' }}
        >
          <p>&copy; {new Date().getFullYear()} {siteConfig.name}. All Rights Reserved.</p>
        </div>
      </div>
    </footer>
  );
}
