'use client';

import { Header } from '@/components/layout/Header';
import { Footer } from '@/components/layout/Footer';
import { useSiteConfig } from '@/hooks/use-site-config';
import { Skeleton } from './ui/skeleton';

export default function PageWrapper({
  children,
}: {
  children: React.ReactNode;
}) {
  const { isLoading } = useSiteConfig();

  if (isLoading) {
    return (
      <div className="relative flex min-h-dvh flex-col">
        <Header />
        <main className="flex-1">
          <div className="container py-12">
            <Skeleton className="h-[60vh] w-full" />
          </div>
        </main>
        <Footer />
      </div>
    );
  }

  return (
    <div className="relative flex min-h-dvh flex-col">
      <Header />
      <main className="flex-1">{children}</main>
      <Footer />
    </div>
  );
}
