import { RepairBookingForm } from '@/components/forms/RepairBookingForm';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { HardHat, Wrench, PackageCheck } from 'lucide-react';

export const metadata = {
  title: 'Book a Repair - REGIMENZ ELECTRONICS INVESTMENT',
  description: 'Schedule a repair for your device. Fast, reliable, and professional service.',
};

const repairSteps = [
    {
      icon: Wrench,
      title: '1. Describe the Issue',
      description: 'Fill out the form with your device details and the problem you are facing. Be as descriptive as possible.',
    },
    {
      icon: HardHat,
      title: '2. Get a Quote',
      description: 'Our team will review your request and contact you with a preliminary quote and repair timeline.',
    },
    {
      icon: PackageCheck,
      title: '3. Drop-off & Pickup',
      description: 'Bring your device to our workshop. We\'ll notify you as soon as it\'s repaired and ready for pickup.',
    },
  ];

export default function RepairsPage() {
  return (
    <div className="container py-12 md:py-16">
      <div className="text-center">
        <h1 className="text-4xl font-extrabold tracking-tight lg:text-5xl">
          Device Repair Service
        </h1>
        <p className="mt-4 max-w-2xl mx-auto text-lg text-muted-foreground">
          Having trouble with your device? Schedule a repair with our expert technicians.
        </p>
      </div>
      <div className="mt-12 grid gap-12 md:grid-cols-2">
        <div className="space-y-8">
            <h2 className="text-3xl font-bold tracking-tight">How It Works</h2>
            {repairSteps.map((step, index) => (
                <Card key={index} className="bg-muted/30">
                    <CardHeader className="flex flex-row items-center gap-4">
                        <step.icon className="h-10 w-10 text-primary" />
                        <CardTitle>{step.title}</CardTitle>
                    </CardHeader>
                    <CardContent>
                        <p className="text-muted-foreground">{step.description}</p>
                    </CardContent>
                </Card>
            ))}
        </div>
        <div>
          <RepairBookingForm />
        </div>
      </div>
    </div>
  );
}
