'use client';

import { ProductList } from '@/components/products/ProductList';
import { categories, type Category, Product } from '@/lib/data';
import { useMemo } from 'react';
import { useCollection, useFirestore, useMemoFirebase } from '@/firebase';
import { collection, query, where } from 'firebase/firestore';

function CategoryProductList({ categoryId }: { categoryId: string }) {
    const firestore = useFirestore();
    const productsQuery = useMemoFirebase(() => {
        if (!firestore) return null;
        return query(collection(firestore, 'products'), where('category', '==', categoryId));
    }, [firestore, categoryId]);

    const { data: products, isLoading } = useCollection<Product>(productsQuery);

    if (isLoading) {
        return <ProductList products={[]} isLoading={true} />;
    }

    if (!products || products.length === 0) {
        return <p>No products in this category yet.</p>;
    }

    return <ProductList products={products} isLoading={false} />;
}


export default function ProductsPage() {

  return (
    <>
      <main className="container py-12 md:py-16">
        <div className="text-center">
          <h1 className="text-4xl font-extrabold tracking-tight lg:text-5xl">
            Our Products
          </h1>
          <p className="mx-auto mt-4 max-w-2xl text-lg text-muted-foreground">
            Find everything you need, from replacement parts to the latest
            gadgets.
          </p>
        </div>
        <div className="mt-12 space-y-12">
          {categories.map((category: Category) => (
            <section key={category.id} id={category.id}>
              <h2 className="mb-6 border-b pb-2 text-2xl font-bold tracking-tight">
                {category.name}
              </h2>
              <CategoryProductList categoryId={category.id} />
            </section>
          ))}
        </div>
      </main>
    </>
  );
}
