'use client';

import { useMemo } from 'react';
import { Hero } from '@/components/sections/Hero';
import { ProductList } from '@/components/products/ProductList';
import { Testimonials } from '@/components/sections/Testimonials';
import { Separator } from '@/components/ui/separator';
import { useCollection, useFirestore, useMemoFirebase } from '@/firebase';
import { collection } from 'firebase/firestore';
import { Product } from '@/lib/data';

export default function Home() {
  const firestore = useFirestore();
  const productsCollection = useMemoFirebase(
    () => collection(firestore, 'products'),
    [firestore]
  );
  const { data: products, isLoading } = useCollection<Product>(productsCollection);

  const featuredProducts = useMemo(() => products || [], [products]);

  return (
    <>
      <Hero />
      <section id="products" className="py-12 md:py-20">
        <div className="container">
          <h2 className="mb-8 text-center text-3xl font-bold tracking-tight md:text-4xl">
            Featured Products
          </h2>
          <ProductList products={featuredProducts} isLoading={isLoading} />
        </div>
      </section>
      <Separator />
      <section id="testimonials" className="bg-muted/50 py-12 md-py-20">
        <div className="container">
          <Testimonials />
        </div>
      </section>
    </>
  );
}
