'use client';

import { useSiteConfig } from '@/hooks/use-site-config';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Phone, MapPin } from 'lucide-react';
import { ContactForm } from '@/components/forms/ContactForm';
import { useEffect } from 'react';

export default function ContactPage() {
  const { siteConfig } = useSiteConfig();
  
  useEffect(() => {
    document.title = `Contact Us - ${siteConfig.name}`;
  }, [siteConfig.name]);

  return (
    <div className="container py-12 md:py-16">
      <div className="text-center">
        <h1 className="text-4xl font-extrabold tracking-tight lg:text-5xl">
          Contact Us
        </h1>
        <p className="mt-4 max-w-2xl mx-auto text-lg text-muted-foreground">
          We're here to help. Reach out with any questions or visit us in-store.
        </p>
      </div>
      <div className="mt-12 grid gap-12 md:grid-cols-2">
        <div>
            <Card className="mb-8">
                <CardHeader>
                    <CardTitle>Our Location</CardTitle>
                    <CardDescription>{siteConfig.location}</CardDescription>
                </CardHeader>
                <CardContent className="space-y-4">
                    <div className="aspect-video overflow-hidden rounded-lg">
                        <iframe
                            src={siteConfig.googleMapsEmbed}
                            width="100%"
                            height="100%"
                            style={{ border: 0 }}
                            allowFullScreen={false}
                            loading="lazy"
                            referrerPolicy="no-referrer-when-downgrade"
                        ></iframe>
                    </div>
                    <div className="flex gap-4">
                        <Button asChild className="flex-1">
                            <a href={`tel:${siteConfig.phone}`}><Phone className="mr-2 h-4 w-4"/> Call Now</a>
                        </Button>
                        <Button asChild variant="secondary" className="flex-1">
                            <a href={siteConfig.googleMapsLink} target="_blank" rel="noopener noreferrer"><MapPin className="mr-2 h-4 w-4"/> Get Directions</a>
                        </Button>
                    </div>
                </CardContent>
            </Card>
        </div>
        <div>
          <ContactForm />
        </div>
      </div>
    </div>
  );
}
