
'use client';

import Image from 'next/image';
import { useSiteConfig } from '@/hooks/use-site-config';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Users, ThumbsUp, Heart } from 'lucide-react';
import { useCollection, useFirestore, useMemoFirebase } from '@/firebase';
import { collection } from 'firebase/firestore';
import { GalleryImage } from '@/lib/data';
import { Skeleton } from '@/components/ui/skeleton';


export default function AboutPage() {
  const { siteConfig } = useSiteConfig();
  const firestore = useFirestore();
  const galleryCollection = useMemoFirebase(
    () => collection(firestore, 'gallery'),
    [firestore]
  );
  const { data: galleryImages, isLoading } = useCollection<GalleryImage>(galleryCollection);

  return (
    <div className="container py-12 md:py-16">
      <div className="mx-auto max-w-4xl">
        <div className="text-center">
          <h1 className="text-4xl font-extrabold tracking-tight lg:text-5xl">
            About {siteConfig.name}
          </h1>
          <p className="mt-4 text-lg text-muted-foreground">
            Established {siteConfig.established}, we are Freetown's trusted source for electronics. We are more than just a shop; we are your partners in technology.
          </p>
        </div>

        <Card className="mt-12">
          <CardHeader>
            <CardTitle>Our Mission</CardTitle>
          </CardHeader>
          <CardContent>
            <p className="text-muted-foreground">
              Our mission is to empower the Freetown community by providing reliable, affordable, and high-quality electronic solutions. We are driven by a passion for technology and a commitment to making it accessible to everyone. From sourcing genuine, top-tier parts to performing expert, meticulous repairs, we are dedicated to achieving excellence and ensuring complete customer satisfaction. We believe in building lasting, trust-based relationships by ensuring every product we sell and every service we provide not only meets but exceeds expectations. Our goal is to enhance our customers' daily lives, keep them seamlessly connected in a rapidly evolving digital world, and contribute positively to the technological growth of our community.
            </p>
          </CardContent>
        </Card>

        <section className="mt-12">
          <h2 className="mb-6 text-center text-3xl font-bold">
            Why Choose Us?
          </h2>
          <div className="grid grid-cols-1 gap-8 md:grid-cols-3">
             <Card>
              <CardHeader className="flex-row items-center gap-4">
                <Users className="h-10 w-10 text-primary" />
                <CardTitle>Expert Team</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground">
                  Our technicians are certified and passionate about technology, ensuring your devices are handled with professional care.
                </p>
              </CardContent>
            </Card>
            <Card>
              <CardHeader className="flex-row items-center gap-4">
                <ThumbsUp className="h-10 w-10 text-primary" />
                <CardTitle>Quality Guaranteed</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground">
                  We stand by our work. We use only genuine parts and offer warranties on our repairs and products for your peace of mind.
                </p>
              </CardContent>
            </Card>
            <Card>
              <CardHeader className="flex-row items-center gap-4">
                <Heart className="h-10 w-10 text-primary" />
                <CardTitle>Customer First</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground">
                    Your satisfaction is our priority. We provide transparent pricing, honest advice, and friendly service every time.
                </p>
              </CardContent>
            </Card>
          </div>
        </section>

        <section className="mt-12">
          <h2 className="mb-6 text-center text-3xl font-bold">
            See Us In Action
          </h2>
          <div className="aspect-video overflow-hidden rounded-lg border">
            <iframe
              width="100%"
              height="100%"
              src="https://www.youtube.com/embed/sOXR_gIqfNo"
              title="YouTube video player"
              frameBorder="0"
              allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
              allowFullScreen
            ></iframe>
          </div>
        </section>

        <section className="mt-12">
          <h2 className="mb-6 text-center text-3xl font-bold">
            WORKERS IN REGIMENZ ELECTRONICS INVESTMENT
          </h2>
          {isLoading ? (
            <div className="grid grid-cols-2 gap-4 md:grid-cols-3">
              {[...Array(6)].map((_, i) => (
                <div key={i} className="space-y-2">
                    <Skeleton className="h-48 w-full" />
                    <Skeleton className="h-5 w-3/4" />
                    <Skeleton className="h-4 w-1/2" />
                </div>
              ))}
            </div>
          ) : (
            <div className="grid grid-cols-2 gap-6 md:grid-cols-3">
              {galleryImages?.map((image) => (
                <div key={image.id}>
                    <div className="overflow-hidden rounded-lg shadow-md">
                        <Image
                            src={image.imageUrl}
                            alt={image.description}
                            width={400}
                            height={400}
                            className="h-full w-full object-cover transition-transform hover:scale-105"
                            data-ai-hint={image.imageHint}
                        />
                    </div>
                    {image.name && (
                        <div className="mt-2 text-center">
                            <p className="font-semibold">{image.name}</p>
                            {image.role && <p className="text-sm text-muted-foreground">{image.role}</p>}
                        </div>
                    )}
                </div>
              ))}
            </div>
          )}
        </section>
      </div>
    </div>
  );
}
