import { z } from 'genkit';

/**
 * @fileOverview Schemas for the generate-review-flow.
 *
 * - GenerateReviewInputSchema - Zod schema for the input of the generateReview function.
 * - GenerateReviewInput - The TS type for the input.
 * - GenerateReviewOutputSchema - Zod schema for the output of the generateReview function.
 * - GenerateReviewOutput - The TS type for the output.
 */

export const GenerateReviewInputSchema = z.object({
  productName: z.string().describe('The name of the product to review.'),
  productDescription: z.string().describe('The description of the product.'),
});
export type GenerateReviewInput = z.infer<typeof GenerateReviewInputSchema>;

export const GenerateReviewOutputSchema = z.object({
  review: z
    .string()
    .describe(
      'A positive product review, written in a mix of English and Sierra Leonean Krio. It should sound authentic and enthusiastic, like a real customer from Freetown.'
    ),
  reviewerName: z.string().describe("The name of the reviewer, which should be a random Sierra Leonean name."),
});
export type GenerateReviewOutput = z.infer<typeof GenerateReviewOutputSchema>;
