'use server';
/**
 * @fileOverview An AI flow to generate a product review in English and Krio.
 *
 * - generateReview - A function that takes product details and returns a review.
 */

import { ai } from '@/ai/genkit';
import {
  GenerateReviewInputSchema,
  type GenerateReviewInput,
  GenerateReviewOutputSchema,
  type GenerateReviewOutput,
} from '@/ai/schemas/review-schemas';

const reviewerNames = [
    'Fatu Kamara', 'Mohamed Sesay', 'Aminata Conteh', 'Ibrahim Jalloh', 
    'Zainab Turay', 'Abu Bakarr', 'Isata Kallon', 'Santigie Kargbo', 
    'Hassan Bangura', 'Adama Koroma', 'Sulaiman Bah', 'Mariama Sheriff'
];

function getRandomReviewerName() {
    const randomIndex = Math.floor(Math.random() * reviewerNames.length);
    return reviewerNames[randomIndex];
}

export async function generateReview(input: GenerateReviewInput): Promise<GenerateReviewOutput> {
  return generateReviewFlow(input);
}

const prompt = ai.definePrompt({
  name: 'generateReviewPrompt',
  input: { schema: GenerateReviewInputSchema },
  output: { schema: GenerateReviewOutputSchema },
  prompt: `You are an enthusiastic product reviewer from Freetown, Sierra Leone.
Your task is to write a short, positive, and authentic-sounding review for a product from REGIMENZ ELECTRONICS INVESTMENT.
Your review must be a mix of English and Sierra Leonean Krio. It should be lively, unique, and praise the product's quality and the shop's excellent service.
Do not use the customer's name in the review.

Keep it concise (2-4 sentences).

Here is the product information:
Product Name: {{{productName}}}
Product Description: {{{productDescription}}}

Example of the style you should use: "Wow, dis product ya fine! I bin buy am last week, and e dey work like magic. I gladi for di way REGIMENZ de help we. Tenki ya!"
Another Example: "Ah swear, dis thing nor get duplicate. Di quality dey top-notch and di service na faya. Big up REGIMENZ for holding us down!"
`,
});

const generateReviewFlow = ai.defineFlow(
  {
    name: 'generateReviewFlow',
    inputSchema: GenerateReviewInputSchema,
    outputSchema: GenerateReviewOutputSchema,
  },
  async (input) => {
    const { output } = await prompt(input);
    if (output) {
        return {
            review: output.review,
            reviewerName: getRandomReviewerName(),
        }
    }
    // Fallback in case of an error
    return {
        review: "This product is great! We highly recommend it.",
        reviewerName: "A Happy Customer",
    }
  }
);
